<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loading_screen_settings', function (Blueprint $table) {
            $table->id();
            $table->string('logo')->nullable();
            $table->string('background_image')->nullable();
            $table->string('background_color')->default('#1E1E1E');
            $table->string('primary_color')->default('#4B8BFF');
            $table->boolean('enable_music')->default(false);
            $table->string('music_file')->nullable();
            $table->float('music_volume')->default(0.5);
            $table->boolean('enable_tips')->default(true);
            $table->boolean('enable_server_info')->default(true);
            $table->boolean('enable_loading_bar')->default(true);
            $table->boolean('enable_player_info')->default(true);
            $table->boolean('enable_map_info')->default(true);
            $table->boolean('enable_community_links')->default(true);
            $table->json('server_rules')->nullable();
            $table->json('tips')->nullable();
            $table->json('community_links')->nullable();
            $table->text('custom_css')->nullable();
            $table->text('custom_js')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loading_screen_settings');
    }
};
